;Copyright 1997, 1999  by Henter-Joyce, Inc.
;Scripts for JAWS Dictionary Wizard

;Pulled strings out into jdict.jsm.  6/4/97, cw
;updated and modified 03/29/99 by j.c

include "jdiction.jsm"
include "hjconst.jsh"

globals
	int JDictFirsttime ; to say auto start message only first time

Function AutoStartEvent ()
if (JDictFirstTime == 0) then
let JDictFirstTime = 1
if GetVerbosity() == beginner then
Say(msg1, ot_help) ;"press control plus shift plus d to modify the default dictionary file"
Say(msg2, ot_help)  ;"otherwise changes will effect only the current application"
EndIf ; verbosity beginner
endif ; first time
EndFunction

Script ScriptFileName ()
;wn3="Dictionary Wizard"
ScriptAndAppNames (wn3)
EndScript

Script  HotKeyHelp()
var
	string RealWindowName
let RealWindowName = GetWindowName (GetRealWindow(GetCurrentWindow()))
SaveCursor()
InvisibleCursor()
;fs4="Search for Entries"
if (FindString (GetFocus(), fs4, S_TOP, S_UNRESTRICTED)) then
;Main Screen
	Say(msg5, ot_help) ;"Add button use alt eigh"
	Say(msg6, ot_help) ;"change button use alt c"
	Say(msg7, ot_help) ;"Search for entries use alt s"
	Say(msg8, ot_help) ;"delete button use alt d"
	Say(msg9, ot_help) ;"Dictionary entries listbox use alt e"
	Say(msg10, ot_help) ;"the dictionary wizard is used to add rules to jaws dictionary files"
	Say(msg11, ot_help) ;"each rule is composed of an actual word and a replacement word"
	Say(msg12, ot_help) ;"an actual word is a word as it appears on the screen"
	Say(msg13 + msg14, ot_help) ;" jaws encounters an actual word"
	Say(msg15, ot_help) ;"you can delete change and add rules to dictionary files using this utility"
	RestoreCursor ()
	return
endif
;wn16="Change Dictionary Definition"
if (RealWindowName == wn16) then
	Say(msg17, ot_help) ;"Use this dialog to change an existing dictionary definition"
	Say(msg18, ot_help) ;"to hear the actual word use alt eigh"
	Say(msg19, ot_help) ;"Replacement word edit use alt r"
	Say(msg20, ot_help) ;"ok button use alt o"
	Say(msg21, ot_help) ;"cancel button use alt c"
	RestoreCursor ()
	return
endif

;wn22="Correct Dictionary Definition"
if (RealWindowName == wn22) then
	Say(msg23, ot_help) ;"Use this dialog to correct a dictionary entry that is not correctly formatted"
	Say(msg24, ot_help) ;"to hear the existing rule use alt u"
	Say(msg25, ot_help) ;"Actual word edit use alt eigh"
	Say(msg19, ot_help) ;"Replacement word edit use alt r"
	Say(msg20, ot_help) ;"ok button use alt o"
	Say(msg21, ot_help) ;"cancel button use alt c"
	RestoreCursor ()
	return
endif
HotKeyHelpDefaultLoop ()
RestoreCursor()
EndScript

Script  SayActualWord()
var
	handle RealWindowHandle,
	string RealWindowName
let RealWindowHandle = GetRealWindow (GetFocus())
let RealWindowName = GetWindowName (RealWindowHandle)
;wn16="Change Dictionary Definition"
if (RealWindowName == wn16) then
	SaveCursor()
	InvisibleCursor()
	MoveToControl (RealWindowHandle, 1027)
	Say(msg26, ot_message) ;"Actual word"
	SayControl(GetCurrentWindow())
else
	{alt+a}
EndIf
EndScript

Script  SayCurrentRule()
var
	handle RealWindowHandle,
	string RealWindowName
let RealWindowHandle = GetRealWindow (GetFocus())
let RealWindowName = GetWindowName (RealWindowHandle)
;wn22="Correct Dictionary Definition"
if (RealWindowName == wn22) then
	SaveCursor()
	InvisibleCursor()
	MoveToControl (RealWindowHandle, 1030)
	Say(msg27, ot_message) ;"Current Rule"
	SayControl(GetCurrentWindow())
	RestoreCursor()
else
	{alt+u}
EndIf
EndScript

Script ScreenSensitiveHelp ()
var
	int theID,
	string RealWindowName
let theID = GetControlID (GetFocus())
let RealWindowName = GetWindowName (GetRealWindow(GetCurrentWindow()))
SaveCursor()
InvisibleCursor()
;fs4="Search for Entries"
if (FindString (GetFocus(), fs4, S_TOP, S_UNRESTRICTED)) then
	if (theID == 1000) then
		Say(msg28, ot_help) ;"this is an incremental search edit"
		Say(msg29 + msg30, ot_help)	 ;" entries are located in the dictionary entries list box"
		RestoreCursor ()
		return
	endif
	if (theID == 1001) then
		Say(msg31, ot_help) ;"this list box contains the list of original entries and their replacements"
		Say(msg32, ot_help)	 ;"this list changes as dictionary entries are added changed and deleted"
		Say(msg33, ot_help) ;"press alt c to change the current list item"
		Say(msg34, ot_help) ;"press alt d to delete the current list item"
		Say(msg35, ot_help) ;"use the arrow keys to select an item"
		RestoreCursor ()
		return
	endif
	if (theID == 1002) then
		Say(msg36, ot_help) ;"add items to the list of dictionary entries"
		Say(msg37, ot_help) ;"press alt eigh to activate this button"
		RestoreCursor ()
		return
	endif
	if (theID == 1003) then
		Say(msg38, ot_help) ;"change the selected dictionary entry"
		Say(msg39, ot_help) ;"press alt c to activate this button"
		Say(msg40, ot_help) ;"to select a dictionary entry press alt e and use the arrow keys to select"
		RestoreCursor ()
		return
	endif
	if (theID == 1004) then
		Say(msg41, ot_help) ;"delete items from the list of dictionary entries"
		Say(msg42, ot_help) ;"press alt d to activate this button"
		Say(msg40, ot_help) ;"to select a dictionary entry press alt e and use the arrow keys to select"
		RestoreCursor ()
		return
	endif
endif

;wn43="Add Dictionary Definition"
if (RealWindowName == wn43) then
	if (theID == 1007) then
		Say(msg44, ot_help) ;"type the word that you want to replace"
		Say(msg45, ot_help) ;"use tab or shift tab to move to the next or prior control"
		RestoreCursor ()
		return
	endif
	if (theID == 1008) then
		Say(msg46, ot_help) ;"type the replacement word"
		Say(msg45, ot_help) ;"use tab or shift tab to move to the next or prior control"
		RestoreCursor ()
		return
	endif
endif

;wn16="Change Dictionary Definition"
if (RealWindowName == wn16) then
	if (theID == 1024) then
		Say(msg46,ot_help) ;"type the replacement word"
		Say(msg45, ot_help) ;"use tab or shift tab to move to the next or prior control"
		Say(msg18, ot_help) ;"to hear the actual word use alt eigh"
		RestoreCursor ()
		return
	endif
endif
;wn22="Correct Dictionary Definition"
if (RealWindowName == wn22) then
	if (theID == 1028) then
		Say(msg44, ot_help) ;"type the word that you want to replace"
		Say(msg45, ot_help) ;"use tab or shift tab to move to the next or prior control"
		RestoreCursor ()
		return
	endif
	if (theID == 1029) then
		Say(msg46, ot_help) ;"type the replacement word"
		Say(msg45, ot_help) ;"use tab or shift tab to move to the next or prior control"
		RestoreCursor ()
		return
	endif
endif
if (theID == 1) then
	Say(msg47, ot_help) ;"okay the changes made in this dialog and return to the main window"
	Say(msg48, ot_help) ;"use alt o to activate this button"
	RestoreCursor ()
	return
endif
if (theID == 2) then
	Say(msg49, ot_help) ;"cancel the changes made in this dialog and return to the main window"
	Say(msg50, ot_help) ;"use alt c to activate this button"
	RestoreCursor ()
	return
endif
RestoreCursor ()
PerformScript ScreenSensitiveHelp ()
EndScript

Script OpenDefaultFile ()
{control+shift+d}
pause() 
Say(GetWindowName (GetAppMainWindow(GetFocus())), ot_window_name)
EndScript